$(function(){
  'use strict';

  var ctx1 = document.getElementById('chartBar1').getContext('2d');
  var myChart1 = new Chart(ctx1, {
    type: 'bar',
    data: {
      labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
      datasets: [{
        label: '# of Votes',
        data: [12, 39, 20, 10, 25, 18],
        backgroundColor: '#27AAC8'
      }]
    },
    options: {
      legend: {
        display: false,
          labels: {
            display: false
          }
      },
      scales: {
        yAxes: [{
          gridLines: {
            color: 'rgba(255,255,255,.08)'
          },
          ticks: {
            beginAtZero:true,
            fontSize: 10,
            fontColor: '#868ba1',
            max: 80
          }
        }],
        xAxes: [{
          gridLines: {
            color: 'rgba(255,255,255,.08)'
          },
          ticks: {
            beginAtZero:true,
            fontSize: 11,
            fontColor: '#868ba1'
          }
        }]
      }
    }
  });

  var ctx2 = document.getElementById('chartBar2').getContext('2d');
  var myChart2 = new Chart(ctx2, {
    type: 'bar',
    data: {
      labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
      datasets: [{
        label: '# of Votes',
        data: [12, 39, 20, 10, 25, 18],
        backgroundColor: [
          '#29B0D0',
          '#2A516E',
          '#F07124',
          '#CBE0E3',
          '#979193'
        ]
      }]
    },
    options: {
      legend: {
        display: false,
          labels: {
            display: false
          }
      },
      scales: {
        yAxes: [{
          gridLines: {
            color: 'rgba(255,255,255,.08)'
          },
          ticks: {
            beginAtZero:true,
            fontSize: 10,
            fontColor: '#868ba1',
            max: 80
          }
        }],
        xAxes: [{
          gridLines: {
            color: 'rgba(255,255,255,.08)'
          },
          ticks: {
            beginAtZero:true,
            fontSize: 11,
            fontColor: '#868ba1'
          }
        }]
      }
    }
  });

  var ctb3 = document.getElementById('chartBar3').getContext('2d');
  new Chart(ctb3, {
    type: 'horizontalBar',
    data: {
      labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
      datasets: [{
        label: '# of Votes',
        data: [12, 39, 20, 10, 25, 18],
        backgroundColor: '#27AAC8'
      }]
    },
    options: {
      legend: {
        display: false,
          labels: {
            display: false
          }
      },
      scales: {
        yAxes: [{
          gridLines: {
            color: 'rgba(255,255,255,.08)'
          },
          ticks: {
            beginAtZero:true,
            fontSize: 10,
            fontColor: '#868ba1'
          }
        }],
        xAxes: [{
          gridLines: {
            color: 'rgba(255,255,255,.08)'
          },
          ticks: {
            beginAtZero:true,
            fontSize: 11,
            fontColor: '#868ba1',
            max: 80
          }
        }]
      }
    }
  });

  var ctb4 = document.getElementById('chartBar4').getContext('2d');
  new Chart(ctb4, {
    type: 'horizontalBar',
    data: {
      labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
      datasets: [{
        label: '# of Votes',
        data: [12, 39, 20, 10, 25, 18],
        backgroundColor: [
          '#29B0D0',
          '#2A516E',
          '#F07124',
          '#CBE0E3',
          '#979193'
        ]
      }]
    },
    options: {
      legend: {
        display: false,
          labels: {
            display: false
          }
      },
      scales: {
        yAxes: [{
          gridLines: {
            color: 'rgba(255,255,255,.08)'
          },
          ticks: {
            beginAtZero:true,
            fontSize: 10,
            fontColor: '#868ba1'
          }
        }],
        xAxes: [{
          gridLines: {
            color: 'rgba(255,255,255,.08)'
          },
          ticks: {
            beginAtZero:true,
            fontSize: 11,
            fontColor: '#868ba1',
            max: 80
          }
        }]
      }
    }
  });

  /* LINE CHART */
  var ctx3 = document.getElementById('chartLine1');
  var myChart3 = new Chart(ctx3, {
    type: 'line',
    data: {
      labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
      datasets: [{
        label: '# of Votes',
        data: [12, 39, 20, 10, 25, 18],
        borderColor: '#27AAC8',
        borderWidth: 1,
        fill: false
      }]
    },
    options: {
      legend: {
        display: false,
          labels: {
            display: false
          }
      },
      scales: {
        yAxes: [{
          gridLines: {
            color: 'rgba(255,255,255,.08)'
          },
          ticks: {
            beginAtZero:true,
            fontSize: 10,
            fontColor: '#868ba1',
            max: 80
          }
        }],
        xAxes: [{
          gridLines: {
            color: 'rgba(255,255,255,.08)'
          },
          ticks: {
            beginAtZero:true,
            fontSize: 11,
            fontColor: '#868ba1'
          }
        }]
      }
    }
  });

  var ctx4 = document.getElementById('chartLine2');
  var myChart4 = new Chart(ctx4, {
    type: 'line',
    data: {
      labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
      datasets: [{
        data: [12, 39, 20, 10, 20, 18],
        borderColor: '#2E5773',
        borderWidth: 1,
        fill: false
      },{
        data: [30, 50, 28, 23, 25, 28],
        borderColor: '#F47322',
        borderWidth: 1,
        fill: false
      }]
    },
    options: {
      legend: {
        display: false,
          labels: {
            display: false
          }
      },
      scales: {
        yAxes: [{
          gridLines: {
            color: 'rgba(255,255,255,.08)'
          },
          ticks: {
            beginAtZero:true,
            fontSize: 10,
            fontColor: '#868ba1',
            max: 80
          }
        }],
        xAxes: [{
          gridLines: {
            color: 'rgba(255,255,255,.08)'
          },
          ticks: {
            beginAtZero:true,
            fontSize: 11,
            fontColor: '#868ba1'
          }
        }]
      }
    }
  });


  /** AREA CHART **/
  var ctx5 = document.getElementById('chartArea1');
  var myChart5 = new Chart(ctx5, {
    type: 'line',
    data: {
      labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
      datasets: [{
        data: [12, 39, 20, 10, 25, 18],
        backgroundColor: '#F07124', //rgba(240, 113, 36, 0.4)
        fill: true,
        borderWidth: 0,
        borderColor: '#fff'
      }]
    },
    options: {
      legend: {
        display: false,
          labels: {
            display: false
          }
      },
      scales: {
        yAxes: [{
          gridLines: {
            color: 'rgba(255,255,255,.08)'
          },
          ticks: {
            beginAtZero:true,
            fontSize: 10,
            fontColor: '#868ba1',
            max: 80
          }
        }],
        xAxes: [{
          gridLines: {
            color: 'rgba(255,255,255,.08)'
          },
          ticks: {
            beginAtZero:true,
            fontSize: 11,
            fontColor: '#868ba1'
          }
        }]
      }
    }
  });

  var ctx6 = document.getElementById('chartArea2');
  new Chart(ctx6, {
    type: 'line',
    data: {
      labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
      datasets: [{
        data: [10, 24, 20, 25, 35, 50],
        backgroundColor: '#2E5773',
        borderWidth: 1,
        fill: true
      },{
        data: [20, 30, 28, 33, 45, 65],
        backgroundColor: '#F47322',
        borderWidth: 1,
        fill: true
      }]
    },
    options: {
      legend: {
        display: false,
          labels: {
            display: false
          }
      },
      scales: {
        yAxes: [{
          gridLines: {
            color: 'rgba(255,255,255,.08)'
          },
          ticks: {
            beginAtZero:true,
            fontSize: 10,
            fontColor: '#868ba1',
            max: 80
          }
        }],
        xAxes: [{
          gridLines: {
            color: 'rgba(255,255,255,.08)'
          },
          ticks: {
            beginAtZero:true,
            fontSize: 11,
            fontColor: '#868ba1'
          }
        }]
      }
    }
  });

  /** STACKED BAR CHART **/
  var ctx7 = document.getElementById('chartStacked1');
  new Chart(ctx7, {
    type: 'bar',
    data: {
      labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
      datasets: [{
        data: [10, 24, 20, 25, 35, 50],
        backgroundColor: '#29B0D0',
        borderWidth: 1,
        fill: true
      },{
        data: [10, 24, 20, 25, 35, 50],
        backgroundColor: '#2E5773',
        borderWidth: 1,
        fill: true
      },{
        data: [20, 30, 28, 33, 45, 65],
        backgroundColor: '#F47322',
        borderWidth: 1,
        fill: true
      }]
    },
    options: {
      legend: {
        display: false,
          labels: {
            display: false
          }
      },
      scales: {
        yAxes: [{
          gridLines: {
            color: 'rgba(255,255,255,.08)'
          },
          ticks: {
            beginAtZero:true,
            fontSize: 11,
            fontColor: '#868ba1'
          },
          stacked: true
        }],
        xAxes: [{
          gridLines: {
            color: 'rgba(255,255,255,.08)'
          },
          ticks: {
            beginAtZero:true,
            fontSize: 11,
            fontColor: '#868ba1'
          },
          stacked: true
        }]
      }
    }
  });

  var ctx8 = document.getElementById('chartStacked2');
  new Chart(ctx8, {
    type: 'horizontalBar',
    data: {
      labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
      datasets: [{
        data: [10, 24, 20, 25, 35, 50],
        backgroundColor: '#29B0D0',
        borderWidth: 1,
        fill: true
      },{
        data: [10, 24, 20, 25, 35, 50],
        backgroundColor: '#2E5773',
        borderWidth: 1,
        fill: true
      },{
        data: [20, 30, 28, 33, 45, 65],
        backgroundColor: '#F47322',
        borderWidth: 1,
        fill: true
      }]
    },
    options: {
      legend: {
        display: false,
          labels: {
            display: false
          }
      },
      scales: {
        yAxes: [{
          gridLines: {
            color: 'rgba(255,255,255,.08)'
          },
          ticks: {
            beginAtZero:true,
            fontSize: 11,
            fontColor: '#868ba1'
          },
          stacked: true
        }],
        xAxes: [{
          gridLines: {
            color: 'rgba(255,255,255,.08)'
          },
          ticks: {
            beginAtZero:true,
            fontSize: 11,
            fontColor: '#868ba1'
          },
          stacked: true
        }]
      }
    }
  });

  /** SPECIFIC GRID LINE COLOR **/
  var ctx9 = document.getElementById('chartArea3');
  new Chart(ctx9, {
    type: 'line',
    data: {
      labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
      datasets: [{
        data: [10, 24, 20, 25, 35, 50],
        backgroundColor: 'rgba(46,87,115,.4)',
        borderWidth: 1,
        fill: true
      },{
        data: [20, 30, 28, 33, 45, 65],
        backgroundColor: 'rgba(41,176,208,.4)',
        borderWidth: 1,
        fill: true
      }]
    },
    options: {
      legend: {
        display: false,
          labels: {
            display: false
          }
      },
      scales: {
        yAxes: [{
          gridLines: {
            drawBorder: false,
            color: ['', '', '#cc0000']
          },
          ticks: {
            beginAtZero:true,
            fontSize: 10,
            fontColor: '#868ba1',
            max: 80
          }
        }],
        xAxes: [{
          gridLines: {
            color: 'rgba(255,255,255,.08)'
          },
          ticks: {
            beginAtZero:true,
            fontSize: 11,
            fontColor: '#868ba1'
          }
        }]
      }
    }
  });

  var ctx10 = document.getElementById('chartArea4');
  new Chart(ctx10, {
    type: 'line',
    data: {
      labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
      datasets: [{
        data: [10, 24, 20, 25, 35, 50],
        backgroundColor: 'rgba(46,87,115,.4)',
        borderWidth: 1,
        fill: true
      },{
        data: [20, 30, 28, 33, 45, 65],
        backgroundColor: 'rgba(41,176,208,.4)',
        borderWidth: 1,
        fill: true
      }]
    },
    options: {
      legend: {
        display: false,
          labels: {
            display: false
          }
      },
      scales: {
        yAxes: [{
          gridLines: {
            drawBorder: false,
            color: ['', '#cc0000', '#0ad013']
          },
          ticks: {
            beginAtZero:true,
            fontSize: 10,
            fontColor: '#868ba1',
            max: 80
          }
        }],
        xAxes: [{
          gridLines: {
            color: 'rgba(255,255,255,.08)'
          },
          ticks: {
            beginAtZero:true,
            fontSize: 11,
            fontColor: '#868ba1'
          }
        }]
      }
    }
  });


  /** PIE CHART **/
  var randomScalingFactor = function() {
    return Math.round(Math.random() * 100);
  };

  var datapie = {
    datasets: [{
      data: [
        randomScalingFactor(),
        randomScalingFactor(),
        randomScalingFactor(),
        randomScalingFactor(),
        randomScalingFactor(),
      ],
      backgroundColor: [
        '#29B0D0',
        '#4C6579',
        '#F57E2E',
        '#C8E0E4',
        '#A6A7AC'
      ]
    }]
  };

  var optionpie = {
    responsive: true,
    legend: {
      display: false,
    },
    animation: {
      animateScale: true,
      animateRotate: true
    }
  };

  // For a doughnut chart
  var ctx6 = document.getElementById('chartPie');
  var myPieChart6 = new Chart(ctx6, {
    type: 'doughnut',
    data: datapie,
    options: optionpie
  });

  // For a pie chart
  var ctx7 = document.getElementById('chartDonut');
  var myPieChart7 = new Chart(ctx7, {
    type: 'pie',
    data: datapie,
    options: optionpie
  });

});
